#!/bin/bash
#SBATCH --nodes=1
#SBATCH --gres=gpu:2
#SBATCH --ntasks-per-node=1
#SBATCH --partition=gpu
#SBATCH --cpus-per-task=12
#SBATCH --job-name=densepose
#SBATCH --time=90:00:00
#SBATCH --mem=80G
#SBATCH --constraint=gmem24G|gmem48G
#SBATCH --constraint=rtx8k|rtx6k|v100s|p40
#SBATCH --exclude=gnodee6,gnodec1

PYTHON='/scratch/shared/beegfs/yuki/envs/py37/bin/python3'


EXP_STR=$1

EXPERIMENT_PATH="/scratch/shared/beegfs/yuki/adiwol/experiments/yuki/${EXP_STR}"
OUTPUT_DIR="${EXPERIMENT_PATH}/DensePose_1x_bnR50"
mkdir -p ${OUTPUT_DIR}

cd detection/detectron2/projects/DensePose

${PYTHON} train_net.py --config-file configs/densepose_rcnn_R_50_FPN_s1x.yaml \
        --num-gpus 2  --dist-url "auto"  \
        SOLVER.CHECKPOINT_PERIOD 30000 \
        MODEL.WEIGHTS ${EXPERIMENT_PATH}/converted.pkl \
        OUTPUT_DIR ${OUTPUT_DIR}
